//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "AlmUseCasePage.h"
#import "NTAG5_NFC_LIB.h"
#import "Config.h"
#import "ALMUseCase.h"
#import "Utils.h"

@interface AlmUseCasePage ()

@end

@implementation AlmUseCasePage

typedef enum : NSUInteger {
    LINE_POSITION_TOP,
    LINE_POSITION_BOTTOM
} LINE_POSITION;

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initViewUIElements];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
    
}

- (IBAction)readALMConfigButtonClick:(UIButton *)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[ALMUseCase sharedInstance] readALM:^(NSData *aData) {
            [self updateUI:aData];
            [self writeLog:cmd_readALMConfiguration response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
    } else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (void)ProcessALM_CONF_01:(int *)mask position:(int *)position resp:(const char *)resp {
    *position = 2;
    *mask = 31;
    int static_phase_offset = (resp[1] >> *position) & *mask;
    (void)(self->_staticPhaseOffsetTextField.text = [NSString stringWithFormat:@"%i",static_phase_offset]);
    
    *position = 1;
    *mask = 1;
    if (((resp[1] >> *position) & *mask) == 0)
        self->_enableResistorLabel.text = @"Resistor disabled";
    else
        self->_enableResistorLabel.text = @"Resistor enabled during ramp";
    
    
    *position = 0;
    *mask = 1;
    if (((resp[1] >> *position) & *mask) == 1)
        self->_phaseShiftEnableCheckbox.image = [UIImage imageNamed: @"checked_checkbox.png"];
    else
        self->_phaseShiftEnableCheckbox.image = [UIImage imageNamed: @"unchecked_checkbox.png"];
}

- (void)ProcessProcessALM_CONF_02:(int *)mask position:(int *)position resp:(const char *)resp {
    if ((resp[2] & 0xC0) == 0x00)
        self->_txResistorValLabel.text = @"High Impedance";
    else if ((resp[2] & 0xC0) == 0x40)
        self->_txResistorValLabel.text = @"300 Ohm";
    else if ((resp[2] & 0xC0) == 0x80)
        self->_txResistorValLabel.text = @"1 kOhm";
    else
        self->_txResistorValLabel.text = @"2.2 kOhm";
    
    *position = 0;
    *mask = 15;
    int damping_period = (resp[2] >> *position) & *mask;
    (void)(self->_alm2enableResistorTextField.text = [NSString stringWithFormat:@"%i",damping_period]);
}

- (void)ProcessProcessALM_CONF_03:(int *)mask position:(int *)position resp:(const char *)resp {
    *position = 3;
    *mask = 7;
    int pll_delay = (resp[3] >> *position) & *mask;
    (void)(self->_alm3TxResistorValueTextField.text = [NSString stringWithFormat:@"%i",pll_delay]);
    
    *position = 0;
    *mask = 7;
    int clamp_delay = (resp[3] >> *position) & *mask;
    (void)(self->_alm3EnableResistorTextField.text = [NSString stringWithFormat:@"%i",clamp_delay]);
}

- (void) updateUI: (NSData *) response{
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        const char *resp = [response bytes];
        
        int position;
        int mask;
        
        // ALM_CONF_00 //
        if ((resp[0] & 0xC0) == 0x00)
            self->_rxResValLabel.text = @"High Impedance";
        else if ((resp[0] & 0xC0) == 0x40)
            self->_rxResValLabel.text = @"300 Ohm";
        else if ((resp[0] & 0xC0) == 0x80)
            self->_rxResValLabel.text = @"1 kOhm";
        else
            self->_rxResValLabel.text = @"2.2 kOhm";
        
        if ((resp[0] & 0x38) == 0x00)
            self->_fieldDetectThresholdLabel.text = @"35 mV";
        else if ((resp[0] & 0x38) == 0x08)
            self->_fieldDetectThresholdLabel.text = @"44 mV";
        else if ((resp[0] & 0x38) == 0x10)
            self->_fieldDetectThresholdLabel.text = @"53 mV";
        else if ((resp[0] & 0x38) == 0x18)
            self->_fieldDetectThresholdLabel.text = @"62 mV";
        else if ((resp[0] & 0x38) == 0x20)
            self->_fieldDetectThresholdLabel.text = @"71 mV";
        else if ((resp[0] & 0x38) == 0x28)
            self->_fieldDetectThresholdLabel.text = @"80 mV";
        else if ((resp[0] & 0x38) == 0x30)
            self->_fieldDetectThresholdLabel.text = @"89 mV";
        else
            self->_fieldDetectThresholdLabel.text = @"98 mV";
        
        // ALM_CONF_01 //
        [self ProcessALM_CONF_01:&mask position:&position resp:resp];
        
        // ALM_CONF_02 //
        [self ProcessProcessALM_CONF_02:&mask position:&position resp:resp];
        
        // ALM_CONF_03 //
        [self ProcessProcessALM_CONF_03:&mask position:&position resp:resp];
    }];
}


/*---------------------- UI METHODS ----------------------*/

- (void) writeLog: (NSString *) cmd response: (NSData *) resp{
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        NSMutableString * sbuf = [[Utils alloc] convertNSDataBytesToHexString:resp];
        
        NSString *log = [NSString stringWithFormat: @"NFC -> %@ \nTAG <- 00%@",
                         cmd, sbuf];
        
        //Get the file path
        NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        NSString *fileName = [documentsDirectory stringByAppendingPathComponent:@"ALMLogs.txt"];
        
        //create file if it doesn't exist
        if(![[NSFileManager defaultManager] fileExistsAtPath:fileName])
            [[NSFileManager defaultManager] createFileAtPath:fileName contents:nil attributes:nil];
        
        //append text to file (you'll probably want to add a newline every write)
        NSFileHandle *file = [NSFileHandle fileHandleForUpdatingAtPath:fileName];
        [file seekToEndOfFile];
        [file writeData:[log dataUsingEncoding:NSUTF8StringEncoding]];
        [file closeFile];
    }];
}

- (void)initViewUIElements {
    _almConf00View.layer.cornerRadius = 8;
    _almConf00View.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _almConf00View.layer.borderWidth = 0.75;
    _almConf00View.backgroundColor = UIColor.whiteColor;
    _almConf01View.layer.cornerRadius = 8;
    _almConf01View.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _almConf01View.layer.borderWidth = 0.75;
    _almConf01View.backgroundColor = UIColor.whiteColor;
    _almConf02View.layer.cornerRadius = 8;
    _almConf02View.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _almConf02View.layer.borderWidth = 0.75;
    _almConf02View.backgroundColor = UIColor.whiteColor;
    _almConf03View.layer.cornerRadius = 8;
    _almConf03View.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _almConf03View.layer.borderWidth = 0.75;
    _almConf03View.backgroundColor = UIColor.whiteColor;
    
    _phaseShiftEnabletext.backgroundColor = UIColor.whiteColor;
    _phaseShiftEnabletext.textColor = UIColor.blackColor;
    _phaseShiftEnabletext.userInteractionEnabled = true;
    _phaseShiftEnableCheckbox.userInteractionEnabled = true;
    
    _staticPhaseOffsetTextField.userInteractionEnabled = true;
    _alm3TxResistorValueTextField.userInteractionEnabled = true;
    _alm3EnableResistorTextField.userInteractionEnabled = true;
    
    [self addLine:_staticPhaseOffsetTextField atPosition:LINE_POSITION_BOTTOM withColor:[UIColor darkGrayColor] lineWitdh:0.5];
    [self addLine:_alm3TxResistorValueTextField atPosition:LINE_POSITION_BOTTOM withColor:[UIColor darkGrayColor] lineWitdh:0.5];
    [self addLine:_alm3EnableResistorTextField atPosition:LINE_POSITION_BOTTOM withColor:[UIColor darkGrayColor] lineWitdh:0.5];
    [self addLine:_alm2enableResistorTextField atPosition:LINE_POSITION_BOTTOM withColor:[UIColor darkGrayColor] lineWitdh:0.5];
    
    _readAlmConfigButton.layer.cornerRadius = 8;
    
    _rxResistorValDropDownList.userInteractionEnabled = true;
    _rxResistorValDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _rxResistorValDropDownList.layer.borderWidth = 0.75;
    
    _fieldDetectThresholdDropDownList.userInteractionEnabled = true;
    _fieldDetectThresholdDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _fieldDetectThresholdDropDownList.layer.borderWidth = 0.75;
    
    _tuningTopologyDropDownList.userInteractionEnabled = true;
    _tuningTopologyDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _tuningTopologyDropDownList.layer.borderWidth = 0.75;
    
    _enableResistorDropDownList.userInteractionEnabled = true;
    _enableResistorDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _enableResistorDropDownList.layer.borderWidth = 0.75;
    
    _txResistorValDropDownList.userInteractionEnabled = true;
    _txResistorValDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _txResistorValDropDownList.layer.borderWidth = 0.75;
    
    _configDropDownList.userInteractionEnabled = true;
    _configDropDownList.backgroundColor = UIColor.whiteColor;
    _configDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth = 0.75;
    _configDropDownList.hidden = true;
    
    [self setAutoHideDropDownMenuListener];
}

- (CATransition *)StartAnimationTransition {
    CATransition *animation         = [CATransition animation];
    animation.type                  = kCATransitionReveal;
    animation.duration              = 0.1;
    return animation;
}

-(void)HideWhenTappedAnywhere{
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = YES;
    
    [self.view endEditing:true];
}

- (void)setAutoHideDropDownMenuListener {
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    singleTap.numberOfTapsRequired = 1;
    
    [self.mainView setUserInteractionEnabled:YES];
    [self.mainView addGestureRecognizer:singleTap];
    
}

- (void) addLine:(UIView *)view atPosition:(LINE_POSITION)position withColor:(UIColor *)color lineWitdh:(CGFloat)width {
    // Add line
    UIView *lineView = [[UIView alloc] init];
    [lineView setBackgroundColor:color];
    [lineView setTranslatesAutoresizingMaskIntoConstraints:NO];
    [view addSubview:lineView];
    
    NSDictionary *metrics = @{@"width" : [NSNumber numberWithFloat:width]};
    NSDictionary *views = @{@"lineView" : lineView};
    [view addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[lineView]|" options: 0 metrics:metrics views:views]];
    
    switch (position) {
        case LINE_POSITION_TOP:
            [view addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-0-[lineView(width)]" options: 0 metrics:metrics views:views]];
            break;
            
        case LINE_POSITION_BOTTOM:
            [view addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[lineView(width)]|" options: 0 metrics:metrics views:views]];
            break;
        default: break;
    }
}

- (IBAction)alm01CheckboxTap:(UIGestureRecognizer *)sender {
    
    if(_phaseShiftEnableCheckbox.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _phaseShiftEnableCheckbox.image = [UIImage imageNamed: img_checked_checkbox];
    }else{
        
        _phaseShiftEnableCheckbox.image = [UIImage imageNamed: img_unchecked_checkbox];
    }
}

- (IBAction)phaseShiftEnableTextTap:(UIGestureRecognizer *)sender {
    if(_phaseShiftEnableCheckbox.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _phaseShiftEnableCheckbox.image = [UIImage imageNamed: img_checked_checkbox];
    }else{
        
        _phaseShiftEnableCheckbox.image = [UIImage imageNamed: img_unchecked_checkbox];
    }
}

- (IBAction)rxResValListViewTap:(UIGestureRecognizer *)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = NO;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = YES;
}

- (IBAction)thresholdListViewTap:(UIGestureRecognizer *)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden                  = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden          = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden          = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden    = NO;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden           = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden           = YES;
}

- (IBAction)tuningTopologyListViewTap:(UIGestureRecognizer *)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = NO;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = YES;
    
}

- (IBAction)rxRestValHighZOptionSelected:(UIGestureRecognizer *)sender {
    _rxResistorValDropDownList.hidden = true;
    _rxResValLabel.text = @"High Impedance";
}

- (IBAction)rxResVal300OhmOptionSelected:(UIGestureRecognizer *)sender {
    _rxResistorValDropDownList.hidden = true;
    _rxResValLabel.text = @"300 Ohm";
}

- (IBAction)rxResVal1kOhmOptionSelected:(UIGestureRecognizer *)sender {
    _rxResistorValDropDownList.hidden = true;
    _rxResValLabel.text = @"1 kOhm";
}

- (IBAction)rxResVal2kOhmOptionSelected:(UIGestureRecognizer *)sender {
    _rxResistorValDropDownList.hidden = true;
    _rxResValLabel.text = @"2.2 kOhm";
}


- (IBAction)theshold35mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"35 mV";
}

- (IBAction)theshold44mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"44 mV";
}

- (IBAction)theshold53mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"53 mV";
}

- (IBAction)theshold62mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"62 mV";
}

- (IBAction)theshold71mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"71 mV";
}

- (IBAction)theshold80mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"80 mV";
}

- (IBAction)theshold89mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"89 mV";
}

- (IBAction)theshold98mVOptionSelected:(id)sender {
    _fieldDetectThresholdDropDownList.hidden = true;
    _fieldDetectThresholdLabel.text = @"98 mV";
}

- (IBAction)tuningTopology000OptionSelected:(id)sender {
    _tuningTopologyLabel.text = @"000";
    _tuningTopologyDropDownList.hidden = true;
}

- (IBAction)enableResistorListTap:(UIGestureRecognizer *)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = NO;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = YES;
}

- (IBAction)enableResistorDisabledOptionSelected:(id)sender {
    _enableResistorDropDownList.hidden = true;
    _enableResistorLabel.text = @"Resistor disabled";
}

- (IBAction)enableResistorEmabledOptionSelected:(id)sender {
    _enableResistorDropDownList.hidden = true;
    _enableResistorLabel.text = @"Resistor enabled during ramp";
}

- (IBAction)txResistorValueListTap:(UIGestureRecognizer *)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = NO;
}

- (IBAction)txRestValHighZOptionSelected:(UIGestureRecognizer *)sender {
    _txResistorValDropDownList.hidden = true;
    _txResistorValLabel.text = @"High Impedance";
}

- (IBAction)txResVal1kOhmOptionSelected:(UIGestureRecognizer *)sender {
    _txResistorValDropDownList.hidden = true;
    _txResistorValLabel.text = @"1 kOhm";
}

- (IBAction)txResVal2kOhmOptionSelected:(UIGestureRecognizer *)sender {
    _txResistorValDropDownList.hidden = true;
    _txResistorValLabel.text = @"2.2 kOhm";
}

- (IBAction)txResVal300OhmOptionSelected:(id)sender {
    _txResistorValDropDownList.hidden = true;
    _txResistorValLabel.text = @"300 Ohm";
}

- (IBAction)navBarButtonClick:(id)sender {
    CATransition *animation = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false)
        _configDropDownList.hidden = true;
    else
        _configDropDownList.hidden = false;
    
    [_enableResistorDropDownList.layer addAnimation:animation forKey:nil];
    _enableResistorDropDownList.hidden = YES;
    
    [_tuningTopologyDropDownList.layer addAnimation:animation forKey:nil];
    _tuningTopologyDropDownList.hidden = YES;
    
    [_fieldDetectThresholdDropDownList.layer addAnimation:animation forKey:nil];
    _fieldDetectThresholdDropDownList.hidden = YES;
    
    [_rxResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _rxResistorValDropDownList.hidden = YES;
    
    [_txResistorValDropDownList.layer addAnimation:animation forKey:nil];
    _txResistorValDropDownList.hidden = YES;
}

@end


